﻿<?php
// Include the database connection file
require_once "db_connect.php";

$stmt = $pdo->prepare("SELECT * FROM vtart ORDER BY 1");
$stmt->execute();
$productos = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="col-xs-12">
    <h1>Productos</h1>
    <div>
        <a class="btn btn-success" href="./formulario.php">Nuevo <i class="fa fa-plus"></i></a>
    </div>
    <br>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Código</th>
                <th>Descripción</th>
                <th>Existencia</th>
                <th>Precio de venta</th>
                <th>Stock Min</th>
                <th>Editar</th>
                <th>Eliminar</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($productos as $row) { ?>
                <tr>
                    <td><?php echo htmlspecialchars($row['vtartcart']); ?></td>
                    <td><?php echo htmlspecialchars($row['vtartdesc']); ?></td>
                    <td><center><?php echo number_format($row['vtartcant'], 2); ?></center></td>
                    <td><center><?php echo number_format($row['vtartpven'], 2); ?></center></td>
                    <td><center><?php echo number_format($row['vtartsmin'], 2); ?></center></td>
                    <?php if ($row['vtartstat'] == 0): ?>
                        <td><center><a class="btn btn-primary btn-xs" href="vt222.php?id=<?php echo htmlspecialchars($row['vtartcart']); ?>">Modificar</a></center></td>
                        <td><center><a class="btn btn-danger btn-xs" href="vt223.php?id=<?php echo htmlspecialchars($row['vtartcart']); ?>">Dar de Baja</a></center></td>
                    <?php else: ?>
                        <td><center><a href="?id=<?php echo htmlspecialchars($row['vtartcart']); ?>"></a></center></td>
                        <td><center><a class="btn btn-success btn-xs" href="vt224.php?id=<?php echo htmlspecialchars($row['vtartcart']); ?>">Dar de Alta</a></center></font></td>
                    <?php endif; ?>
                </tr>
            <?php } ?>
        </tbody>
    </table>
</div>