<?php
date_default_timezone_set('America/La_Paz');
require __DIR__ . '/ticket/autoload.php';
use Mike42\Escpos\Printer;
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;
/*
	Este ejemplo imprime un
	ticket de venta desde una impresora trmica
*/

/*
	Una pequea clase para
	trabajar mejor con
	los productos
	Nota: esta clase no es requerida, puedes
	imprimir usando puro texto de la forma
	que t quieras
*/
class Producto{
	public function __construct($nombre, $precio, $cantidad){
		$this->nombre = $nombre;
		$this->precio = $precio;
		$this->cantidad = $cantidad;
	}
}
 
/*
	Vamos a simular algunos productos. Estos
	podemos recuperarlos desde $_POST o desde
	cualquier entrada de datos. Yo los declarar
	aqu mismo
*/
 
$productos = array(
	new Producto("Papas Fritas", 10, 1),
	new Producto("Pipocas", 22, 2),
	/*
		El nombre del siguiente producto es largo
		para comprobar que la librera
		bajar el texto por nosotros en caso de
		que sea muy largo
	*/
	new Producto("Galletas saladas con un sabor muy salado y un precio excelente", 10, 1.5),
	);
 
/*
	Aqu, en lugar de "POS-58" (que es el nombre de mi impresora)
	escribe el nombre de la tuya. Recuerda que debes compartirla
	desde el panel de control
*/
 
$nombre_impresora = "EPSON TM-U330"; 
$connector = new WindowsPrintConnector($nombre_impresora);
$printer = new Printer($connector);
 
 
/*
	Vamos a imprimir un logotipo
	opcional. Recuerda que esto
	no funcionar en todas las
	impresoras
 
	Pequea nota: Es recomendable que la imagen no sea
	transparente (aunque sea png hay que quitar el canal alfa)
	y que tenga una resolucin baja. En mi caso
	la imagen que uso es de 250 x 250
*/
 
# Vamos a alinear al centro lo prximo que imprimamos
$printer->setJustification(Printer::JUSTIFY_CENTER);
 
/*
	Intentaremos cargar e imprimir
	el logo
*/

//try{
//    $logo = EscposImage::load("logo.png", false);
//    $printer->bitImage($logo);
//}catch(Exception $e){/*No hacemos nada si hay error*/}

/*
	Ahora vamos a imprimir un encabezado
*/
 
$printer->text("Linea 1" . "\n");
$printer->text("Otra linea" . "\n");
#La fecha tambin
$printer->text(date("d-m-Y H:i:s") . "\n");
 
/*
	Ahora vamos a imprimir los
	productos
*/
 
# Para mostrar el total
$total = 0;
foreach ($productos as $producto) {
	$total += $producto->cantidad * $producto->precio;
 
	/*Alinear a la izquierda para la cantidad y el nombre*/
	$printer->setJustification(Printer::JUSTIFY_LEFT);
    $printer->text($producto->cantidad . "x" . $producto->nombre . "\n");
 
    /*Y a la derecha para el importe*/
    $printer->setJustification(Printer::JUSTIFY_RIGHT);
    $printer->text(' $' . $producto->precio . "\n");
}
 
/*
	Terminamos de imprimir
	los productos, ahora va el total
*/
$printer->text("--------\n");
$printer->text("TOTAL: $". $total ."\n");
 
/*
	Podemos poner tambin un pie de pgina
*/
$printer->text("Muchas gracias por su compra\n");

/*Alimentamos el papel 3 veces*/
$printer->feed(3);
 
/*
	Cortamos el papel. Si nuestra impresora
	no tiene soporte para ello, no generar
	ningn error
*/
$printer->cut();
 
/*
	Por medio de la impresora mandamos un pulso.
	Esto es til cuando la tenemos conectada
	por ejemplo a un cajn
*/
$printer->pulse();
 
/*
	Para imprimir realmente, tenemos que "cerrar"
	la conexin con la impresora. Recuerda incluir esto al final de todos los archivos
*/
$printer->close();
?>
